/*
 * XXXX 
 *
 * Fecha 14/05/2007
 * 
 *  
 */
 
package com.ejie.p06b.servlet.presentacion.corredores;


import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejie.p06b.datatype.logic.P06BError;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BErrores;
import com.ejie.p06b.general.P06BPaginas;
import com.ejie.p06b.manager.P06BCorredoresManager;
import com.ejie.p06b.servlet.P06BServletGenerico;
import com.ejie.p06b.util.P06BPage;
import com.ejie.p06b.util.P06BResources;



/**
 *  Esta clase gestiona las peticiones HTTP de la aplicacin.
 */
public class P06BCorredorListadoServlet extends P06BServletGenerico 
{

	//Cambia de idioma en la sesin -> Perfil
	public void ejecutar(HttpServletRequest request, HttpServletResponse response) {
		try {
			P06BPage page = (P06BPage)this.obtenerListaCorredores(request,response);
			//Puede ser que se haya producido un error
			//	Ej. El nmero de pgina no es un nmero vlido
			if(page!=null){
				request.setAttribute("ListaCorredores", (ArrayList)page.getResults());
				request.setAttribute("numTotalEle", page.getTotalElements()+"");
				request.setAttribute("numPagEle", page.getResults().size()+"");
				request.setAttribute("numTotPag", page.getLastPage()+"");
				request.setAttribute("numActPag", page.getPage()+"");
			}
			//Redireccionamos a la pgina de listado corredores
			forward (request, response, P06BPaginas.P06B_JSP_CORREDOR_LISTADO);
		}catch (Exception e){
	      	manejarErrores (request, response, e);
	        return;
	    }
	}
	
	//Obtengo la lista de corredores a partir de la pgina y del filtro
	private P06BPage obtenerListaCorredores(HttpServletRequest request, HttpServletResponse response) throws Exception {
		String where = (String)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"Corredor"+P06BConstantes.P06B_VAR_TEMP_FILTRO);
		String strPag = "";
		if (request.getParameter("numPag")==null){
			strPag = "1";
		}else if ("".equals(request.getParameter("numPag").trim())){
			strPag = "1";			
		}else{
			strPag = request.getParameter("numPag"); 
		}
		String codigoVuelta = request.getParameter("codigoVuelta");
		String columnaVuelta = request.getParameter("columnaVuelta");
		int numPag = 0;
		boolean notIsNum=false;
		ArrayList errors = new ArrayList();
		P06BResources res = (P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS);
		try{
			numPag = new Integer(strPag).intValue();
		}catch (Exception e){
			//Sabemos que es porque el nmero no un nmero vlido
			P06BError error = new P06BError();
			error.setNombreCampo(res.get("pantallas.paginacion.pagina"));
			error.setCodigo(P06BErrores.P06B_ERROR_0004);
			errors.add(error);
			notIsNum=true;
		}
		//Compruebo que la pgina introducida est en un rango vlido
		if(!notIsNum){
			//Si no se ha producido el anterior error
			//Es porque el nmero es un nmero vlido
			//Est dentro del rango de pginas vlidas??
			if((request.getParameter("numTotPag")!=null) 
					&& (numPag<=0 || 
							numPag>Integer.parseInt(request.getParameter("numTotPag")))){
				P06BError error = new P06BError();
				error.setNombreCampo(res.get("pantallas.paginacion.pagina"));
				error.setCodigo(P06BErrores.P06B_ERROR_0012);
				errors.add(error);
				numPag=0;
			}
		}
		
		P06BPage page = P06BCorredoresManager.getInstance().getListadoCorredores(codigoVuelta, columnaVuelta, numPag, where);
		
		if(!errors.isEmpty()){
			request.setAttribute("errors",errors);
		}
		return page;
	}
}